/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.rsf.handlers;

import com.ibm.hwmca.base.rsf.handlers.BaseRsfHandlersErrorIds;
import com.ibm.hwmca.base.rsf.requests.BaseRsfRequestImpl;
import com.ibm.hwmca.base.rsf.requests.BaseRsfResultDetails;
import com.ibm.hwmca.base.rsf.requests.SdrAdditionalData;
import com.ibm.hwmca.base.rsf.requests.SdrFileAdditionalData;
import com.ibm.hwmca.base.rsf.requests.SdrHttpFileUpdate;
import com.ibm.hwmca.base.rsf.requests.SdrHttpRequest;
import com.ibm.hwmca.base.rsf.requests.SdrHttpResponse;
import com.ibm.hwmca.base.rsf.requests.SdrRequestBody;
import com.ibm.hwmca.base.rsf.sas.CredentialUtils;
import com.ibm.hwmca.base.rsf.util.TcpConnection;
import com.ibm.hwmca.base.util.BaseFileControl;
import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.log.MicrocodeLogAttributes;
import com.ibm.hwmca.fw.rcs.path.RcsPath;
import com.ibm.hwmca.fw.rcs.sas.SysInfo;
import com.ibm.hwmca.fw.util.FileUtilities;
import com.ibm.hwmca.fw.util.Trace;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.Socket;
import java.util.StringTokenizer;
import javax.net.ssl.SSLSocket;

public class SdrUtils
implements BaseRsfHandlersErrorIds {
    private static final String TRACE_MASKT = "XRSFSDRT";
    private static final String TRACE_MASKF = "XRSFSDRF";
    private static final String TRACE_MASKD = "XRSFSDRD";
    private static FrameworkClassLogInfo logInfo = new FrameworkClassLogInfo(-44, "SdrHandler");
    private static MicrocodeLogAttributes infoLog = MicrocodeLogAttributes.INFO_LOG;
    private static MicrocodeLogAttributes infoLogDisplayError = new MicrocodeLogAttributes(false, false, true, true, true, true, false, 0);
    private static String addCredentialMethod = "ESAUpdateCredentials";
    private static String addPCredentialClass = "com.ibm.hwmca.p.sa.ServiceAgentUtils";
    private static String addZCredentialClass = "com.ibm.hwmca.z.esa.EsaSdrAdditionalData";
    private static String applicationSSL = "/support/electronic/itssdr/IESproxy.wss";
    private static String applicationLegacy = "/servlet/SDR";
    private static int MAX_LOG_DATA_LENGTH = 200;
    private static File tempPath = null;

    public static SdrHttpResponse sendSdrRequest(RcsPath path, TcpConnection connection, SdrHttpRequest httpRequest, SysInfo owning, SysInfo sending, BaseRsfResultDetails details, BaseRsfRequestImpl request) throws IOException {
        Socket socket;
        String xml = httpRequest.getXmlData();
        Trace.trace(TRACE_MASKT, "-> SdrUtils.sendSdrRequest(Connection= " + connection + ")");
        try {
            socket = connection.getSocket();
        }
        catch (IOException e) {
            SdrUtils.logErrorAndContinue("SdrUtils.sendSdrRequest: exception getting socket for " + connection, e, (short)28486);
            throw e;
        }
        boolean isSSL = false;
        if (socket instanceof SSLSocket) {
            isSSL = true;
        }
        boolean fileOnly = false;
        File file = httpRequest.getDataFile();
        String obtainedFilename = null;
        if (xml == null) {
            if (file == null) {
                SdrUtils.logErrorAndContinue("SdrUtils.sendSdrRequest: null xml and file name", null, (short)28417);
                return new SdrHttpResponse(4, null, null, null, null, httpRequest);
            }
            fileOnly = true;
        } else if (xml.trim().length() == 0) {
            return new SdrHttpResponse(4, null, null, null, null, httpRequest);
        }
        long fileSize = 0L;
        boolean fileReady = false;
        File tempFile = null;
        String tempFileName = null;
        if (file != null) {
            String filename;
            obtainedFilename = filename = file.getAbsolutePath();
            try {
                tempFile = File.createTempFile("iqy", ".tmp", tempPath);
                tempFileName = tempFile.getAbsolutePath();
            }
            catch (IOException ioe) {
                SdrUtils.logErrorAndContinue("SdrUtils.sendSdrRequest: Cannot create temp file", ioe, (short)28449);
                return new SdrHttpResponse(1, null, null, null, null, httpRequest);
            }
            if (request.isLocalRequest()) {
                Trace.trace(TRACE_MASKD, "SdrUtils.sendSdrRequest: copying local file for send to RETAIN");
                try {
                    FileUtilities.copy(filename, tempFileName);
                }
                catch (Exception e) {
                    SdrUtils.logErrorAndContinue("SdrUtils.sendSdrRequest: Unable to copy file locally: " + filename, e, (short)28449);
                    return new SdrHttpResponse(1, null, null, null, null, httpRequest);
                }
            } else {
                Trace.trace(TRACE_MASKD, "SdrUtils.sendSdrRequest: transferring remote file for send to RETAIN");
                if (!request.getFile(tempFileName, filename, true)) {
                    SdrUtils.logErrorAndContinue("SdrUtils.sendSdrRequest: Unable to transfer file from submitting machine", null, (short)28449);
                    return new SdrHttpResponse(1, null, null, null, null, httpRequest, null, obtainedFilename);
                }
            }
            fileSize = tempFile.length();
            Trace.trace(TRACE_MASKF, "File [" + file + "] has fileLength = " + fileSize);
            if (!tempFile.canRead()) {
                Trace.trace(TRACE_MASKF, " can not read fileName [" + file + "]");
                return new SdrHttpResponse(1, null, null, null, null, httpRequest, null, obtainedFilename);
            }
        }
        SdrRequestBody requestBody = null;
        try {
            requestBody = (SdrRequestBody)request.getBody();
        }
        catch (Exception e) {
            SdrUtils.logErrorAndContinue("SdrUtils.sendSdrRequest: Invalid request body", e, (short)28671);
            return new SdrHttpResponse(4, null, null, null, null, httpRequest, null, obtainedFilename);
        }
        boolean noXml = false;
        String credentialClassName = requestBody.isZSeriesRequest() ? addZCredentialClass : addPCredentialClass;
        int fileStart = 0;
        if (fileOnly) {
            SdrHttpFileUpdate data = SdrUtils.addCredentialsToFile(tempFile, owning, sending, credentialClassName);
            xml = data.modifiedHeader;
            fileStart = data.index;
        } else {
            xml = SdrUtils.addCredentials(xml, tempFile, owning, sending, credentialClassName);
        }
        if (xml == null) {
            return new SdrHttpResponse(5, null, null, null, null, httpRequest, null, obtainedFilename);
        }
        int amountData = Math.min(xml.length(), MAX_LOG_DATA_LENGTH);
        SdrUtils.logInfoAndContinue("Sdr header after replacement:\n" + xml.substring(0, amountData), null, (short)28483);
        long dataSize = fileSize - (long)fileStart + (long)xml.length();
        StringBuffer response = new StringBuffer(1000);
        BufferedReader bufferedReader = null;
        PrintStream printStream = null;
        try {
            printStream = new PrintStream(socket.getOutputStream());
        }
        catch (IOException e) {
            SdrUtils.logErrorAndContinue("SdrUtils.sendSdrRequest: exception getting output stream from socket", e, (short)28592);
            throw e;
        }
        if (!fileOnly) {
            String sessionlessRequest = SdrUtils.createHttpHeader(dataSize, isSSL);
            try {
                printStream.print(sessionlessRequest);
            }
            catch (Exception e) {
                SdrUtils.logErrorAndContinue("SdrUtils.sendSdrRequest: Exception sending HTTP header:" + sessionlessRequest, e, (short)28592);
                throw new IOException("Generic Exception Message:" + e.getMessage());
            }
        }
        try {
            printStream.print(xml);
        }
        catch (Exception e) {
            SdrUtils.logErrorAndContinue("SdrUtils.sendSdrRequest: Exception sending XML", e, (short)28592);
            throw new IOException("Generic Exception Message:" + e.getMessage());
        }
        if (fileSize > 0L) {
            byte[] buffer;
            boolean eof = false;
            int recordNumber = 0;
            int bytesRead = 0;
            long bytesRemaining = fileSize - (long)fileStart;
            int remainingHeaderBytes = fileStart;
            Trace.trace(TRACE_MASKD, "fileSize = " + fileSize);
            FileInputStream dataStream = new FileInputStream(tempFile);
            while (remainingHeaderBytes > 0 && !eof) {
                buffer = remainingHeaderBytes > 4000 ? new byte[4000] : new byte[remainingHeaderBytes];
                bytesRead = dataStream.read(buffer);
                if (bytesRead > 0) {
                    remainingHeaderBytes -= bytesRead;
                    Trace.trace(TRACE_MASKF, "SdrUtils: read " + bytesRead + " bytes to be discarded");
                    continue;
                }
                SdrUtils.logInfoAndContinue("SdrUtils: end of file found before header read", null, (short)28453);
                eof = true;
            }
            while (!eof || bytesRemaining > 0L) {
                buffer = bytesRemaining > 4000L ? new byte[4000] : new byte[(int)bytesRemaining];
                ++recordNumber;
                bytesRead = dataStream.read(buffer);
                if (bytesRead > 0) {
                    Trace.trace(TRACE_MASKD, "writing file record number " + recordNumber + ", bytes remaining = " + (bytesRemaining -= (long)bytesRead));
                    try {
                        printStream.write(buffer, 0, buffer.length);
                        continue;
                    }
                    catch (Exception e) {
                        SdrUtils.logErrorAndContinue("SdrUtils.sendSdrRequest: Exception sending file record #" + recordNumber + " for " + buffer.length + " bytes with " + bytesRemaining + " bytes remaining.", e, (short)28592);
                        throw new IOException("Generic Exception Message:" + e.getMessage());
                    }
                }
                eof = true;
            }
            try {
                printStream.flush();
            }
            catch (Exception e) {
                SdrUtils.logErrorAndContinue("SdrUtils.sendSdrRequest: Exception flushing output stream after " + recordNumber + " records", e, (short)28592);
                throw new IOException("Generic Exception Message:" + e.getMessage());
            }
            if (tempFile != null) {
                tempFile.delete();
            }
        }
        try {
            bufferedReader = new BufferedReader(new InputStreamReader(socket.getInputStream()));
        }
        catch (IOException e) {
            SdrUtils.logErrorAndContinue("SdrUtils.sendSdrRequest: IOException creating input stream from socket", e, (short)28592);
            throw e;
        }
        String httpHeader = "";
        String line = null;
        boolean firstTime = true;
        int lineCount = 0;
        try {
            while ((line = bufferedReader.readLine()) != null) {
                Trace.trace(TRACE_MASKD, "SdrUtils.sendSdrRequest(): line = " + ++lineCount + " [" + line + "]");
                if (line.length() == 0 && firstTime) {
                    httpHeader = new String(response);
                    response.setLength(0);
                    firstTime = false;
                    continue;
                }
                if (line.indexOf("sessionless-sdr-return-v2.dtd") < 0) {
                    response.append(line);
                    response.append("\r\n");
                    continue;
                }
                int begin = line.indexOf("SYSTEM");
                int end = line.lastIndexOf("\"");
                line = line.substring(0, begin) + line.substring(end + 1, line.length());
                response.append(line);
                response.append("\r\n");
            }
        }
        catch (IOException e) {
            SdrUtils.logErrorAndContinue("SdrUtils.sendSdrRequest: IOException reading data from socket for line #" + lineCount, e, (short)28592);
            throw e;
        }
        try {
            printStream.close();
            bufferedReader.close();
            socket.close();
        }
        catch (IOException e) {
            SdrUtils.logInfoAndContinue("SdrUtils.sendSdrRequest: IOException closing I/O streams and socket", e, (short)28592);
        }
        StringTokenizer stringTokenizer = new StringTokenizer(httpHeader, " ");
        String stringResponse = response.toString();
        if (stringTokenizer.countTokens() < 3) {
            return new SdrHttpResponse(2, stringResponse, null, null, null, httpRequest, null, obtainedFilename);
        }
        stringTokenizer.nextToken();
        String httpReturnCode = stringTokenizer.nextToken();
        String httpReturnMessage = stringTokenizer.nextToken("\n");
        String xmlRc = SdrUtils.getXmlRc(stringResponse, credentialClassName);
        String message = "SdrUtils: rc from SdrHttpRequest=" + xmlRc;
        if (xmlRc == null) {
            Trace.trace(TRACE_MASKF, "SdrUtils.sendSdrRequest: null xml rc");
            xmlRc = "";
        } else if (xmlRc.length() > 4) {
            xmlRc = xmlRc.substring(0, 4);
        }
        if ((xmlRc.equals("7100") || xmlRc.equals("7150")) && !fileOnly) {
            SdrUtils.logErrorAndContinue(message + ". Owning system credential failure.", null, (short)28482);
            details.setReasonCode(15);
            details.setErrLogMsg(message + ". This indicates an unknown owning system identifier or invalid password.");
        } else if (xmlRc.equals("7101") || xmlRc.equals("7151")) {
            CredentialUtils.clearLocalCredentials();
            SdrUtils.logErrorAndContinue(message + ". Sending system credential failure. Local credential cleared.  Will retry", null, (short)28482);
            details.setReasonCode(16);
            details.setErrLogMsg(message + ". This indicates an unknown sending system identifier or invalid password.");
        } else if (xmlRc.equals("7180") && !fileOnly) {
            SdrUtils.logErrorAndContinue(message + ". Owning system password expired.", null, (short)28482);
            details.setReasonCode(15);
            details.setErrLogMsg(message + ". This indicates the password expired on the owning system");
        } else if (xmlRc.equals("7181")) {
            CredentialUtils.clearLocalCredentials();
            SdrUtils.logErrorAndContinue(message + ". Sending system password expired.  Local credential cleared.  Will retry", null, (short)28482);
            details.setReasonCode(16);
            details.setErrLogMsg(message + ". This indicates the password expired on the sending system");
        }
        Trace.trace(TRACE_MASKF, "SdrUtils.sendSdrRequest(): HTTP return code = " + httpReturnCode);
        return new SdrHttpResponse(0, stringResponse, httpReturnCode, httpReturnMessage, xmlRc, httpRequest, httpHeader, obtainedFilename);
    }

    public static String createHttpHeader(long contentLength, boolean ssl) {
        Trace.trace(TRACE_MASKT, "-> SdrUtils.createHttpHeader(" + contentLength + ")");
        String applName = ssl ? applicationSSL : applicationLegacy;
        String httpHeader = "POST " + applName + " " + "HTTP/" + "1.0" + "\r\n" + "Content-Type: " + "application/octet-stream" + "\r\n" + "Content-Length: " + contentLength + "\r\n" + "Accept: text/*, application/octet-stream\r\n" + "X-XML-Document-Name: sessionless-sdr-request-v2\r\n" + "X-XML-Character-Encoding: UTF8\r\n" + "\r\n";
        Trace.trace(TRACE_MASKT, "<- SdrUtils.createHttpHeader()");
        return httpHeader;
    }

    private static String getXmlRc(String xml, String credentialClass) {
        Trace.trace(TRACE_MASKT, "-> SdrUtils::getXmlRc()");
        Object returnXml = null;
        Class<?> implClass = null;
        try {
            implClass = Class.forName(credentialClass);
        }
        catch (ClassNotFoundException e) {
            Trace.trace(TRACE_MASKT, "<- SdrUtils.getXmlRc() returning null, implementation class not found for " + credentialClass);
            return null;
        }
        try {
            SdrAdditionalData data = (SdrAdditionalData)implClass.newInstance();
            return data.extractXmlRc(xml);
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKF, "getXmlRc: SdrAdditionalData implementation not found.");
            return null;
        }
    }

    private static SdrHttpFileUpdate addCredentialsToFile(File file, SysInfo owningCredentials, SysInfo sendingCredentials, String credentialClass) {
        Trace.trace(TRACE_MASKT, "-> SdrUtils::addCredentialsToFile()");
        Object returnXml = null;
        Class<?> implClass = null;
        try {
            implClass = Class.forName(credentialClass);
        }
        catch (ClassNotFoundException e) {
            Trace.trace(TRACE_MASKT, "<- SdrUtils.addCredentials() returning null, implementation class not found for " + credentialClass);
            return null;
        }
        try {
            SdrFileAdditionalData data = (SdrFileAdditionalData)implClass.newInstance();
            return data.updateConnectionInfo(file, sendingCredentials.getMachineId(), sendingCredentials.getPassword(), owningCredentials.getMachineId(), owningCredentials.getPassword(), "VPN", null, null);
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKF, "addCredentials: SdrAdditionalData implementation not found.  Trying static method");
            Trace.trace(TRACE_MASKF, e);
            SdrUtils.logErrorAndContinue("SdrUtils.addCredentials: Unable to add credentials", null, (short)28671);
            return null;
        }
    }

    private static String addCredentials(String xml, File tempFile, SysInfo owningCredentials, SysInfo sendingCredentials, String credentialClass) {
        Trace.trace(TRACE_MASKT, "-> SdrUtils::addCredentials() using " + credentialClass);
        Object returnXml = null;
        Class<?> implClass = null;
        try {
            implClass = Class.forName(credentialClass);
        }
        catch (ClassNotFoundException e) {
            Trace.trace(TRACE_MASKT, "<- SdrUtils.addCredentials() returning null, implementation class not found for " + credentialClass);
            return null;
        }
        try {
            SdrAdditionalData data = (SdrAdditionalData)implClass.newInstance();
            String result = data.updateConnectionInfo(xml, tempFile, sendingCredentials.getMachineId(), sendingCredentials.getPassword(), owningCredentials.getMachineId(), owningCredentials.getPassword(), "VPN", null, null);
            if (result == null || result.trim().length() == 0) {
                return xml;
            }
            return result;
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKF, "addCredentials: SdrAdditionalData implementation not found.  Trying static method");
            Trace.trace(TRACE_MASKF, e);
            SdrUtils.logErrorAndContinue("SdrUtils.addCredentials: Unable to add credentials", null, (short)28671);
            return null;
        }
    }

    private static void logErrorAndContinue(String errorMsg, Throwable t, short errorId) {
        FrameworkLog errLog;
        Trace.trace(TRACE_MASKF, errorMsg);
        if (t != null) {
            Trace.trace(TRACE_MASKF, t);
            errLog = new FrameworkLog(logInfo, errorId, t);
        } else {
            errLog = new FrameworkLog(logInfo, errorId);
        }
        errLog.add(errorMsg);
        errLog.log(infoLogDisplayError);
    }

    private static void logInfoAndContinue(String errorMsg, Throwable t, short errorId) {
        FrameworkLog errLog;
        Trace.trace(TRACE_MASKF, errorMsg);
        if (t != null) {
            Trace.trace(TRACE_MASKF, t);
            errLog = new FrameworkLog(logInfo, errorId, t);
        } else {
            errLog = new FrameworkLog(logInfo, errorId);
        }
        errLog.add(errorMsg);
        errLog.log(infoLog);
    }

    static {
        try {
            tempPath = new File(BaseFileControl.getFilePath("tmp"));
        }
        catch (HException e) {
            Trace.trace(TRACE_MASKF, "ZPapHandler: static block - Unable to get temp file path");
            new FrameworkLog(logInfo, 28451, e).log(infoLog);
        }
    }
}

